/*############################################################################*/
/*#                                                                          #*/
/*#  ADM mapping rules for DirectSpeaker downmixing.                         #*/
/*#								                                             #*/
/*#  Copyright © 2020 Peter Stitt                                            #*/
/*#                                                                          #*/
/*#  Filename:      AdmMappingRules.h                                        #*/
/*#  Version:       0.1                                                      #*/
/*#  Date:          23/06/2020                                               #*/
/*#  Author(s):     Peter Stitt                                              #*/
/*#  Licence:       LGPL + proprietary                                       #*/
/*#                                                                          #*/
/*############################################################################*/

#include <cmath>

#pragma once

namespace admrender {

	// Structing containing a Mapping Rule c.f. Rec. ITU-R BS.2127-0 sec. 8.1
	struct MappingRule {
		std::string speakerLabel;
		std::vector<std::pair<std::string, double>> gains;

		std::vector<std::string> inputLayouts;

		std::vector<std::string> outputLayouts;
	};

    const double _1_sqrt2 = 1. / sqrt(2.);
    const double sqrt2_3 = std::sqrt(2. / 3.);
    const double _1_sqrt3 = std::sqrt(1. / 3.);

    // Mapping rules from Rec. ITU-R BS.2127-0 Table 16
    const std::vector<MappingRule> mappingRules = 
    {
    {"M+000", {{"M+000", 1.0}}, {}, {}},
    {"M+000",{{"M+030", _1_sqrt2}, {"M-030", _1_sqrt2}},{},{}},
    {"M+060", {{"M+060", 1.0}}, {}, {}},
    {"M-060", {{"M-060", 1.0}}, {}, {}},
    {"M+060", {{"M+030", sqrt2_3}, {"M+110", _1_sqrt3}}, {},{}},
    {"M-060", {{"M-030", sqrt2_3}, {"M-110", _1_sqrt3}},{},{}},
    {"M+060",{{"M+030", _1_sqrt2}, {"M+090", _1_sqrt2}},{},{}},
    {"M-060",{{"M-030", _1_sqrt2}, {"M-090", _1_sqrt2}},{},{}},
    {"M+060", {{"M+030", 1.0}}, {}, {}},
    {"M-060", {{"M-030", 1.0}}, {}, {}},
    {"M+090", {{"M+090", 1.0}}, {}, {}},
    {"M-090", {{"M-090", 1.0}}, {}, {}},
    {"M+090",{{"M+030", _1_sqrt3}, {"M+110", sqrt2_3}},{"9+10+3"},{}},
    {"M-090",{{"M-030", _1_sqrt3}, {"M-110", sqrt2_3}},{"9+10+3"},{}},
    {"M+090",{{"M+030", _1_sqrt2}, {"M+110", _1_sqrt2}},{},{}},
    {"M-090",{{"M-030", _1_sqrt2}, {"M-110", _1_sqrt2}},{},{}},
    {"M+090", {{"M+030", _1_sqrt2}}, {}, {}},
    {"M-090", {{"M-030", _1_sqrt2}}, {}, {}},
    {"M+110", {{"M+110", 1.0}}, {}, {}},
    {"M-110", {{"M-110", 1.0}}, {}, {}},
    {"M+110", {{"M+135", 1.0}}, {}, {}},
    {"M-110", {{"M-135", 1.0}}, {}, {}},
    {"M+110", {{"M+030", _1_sqrt2}}, {}, {}},
    {"M-110", {{"M-030", _1_sqrt2}}, {}, {}},
    {"M+135", {{"M+135", 1.0}}, {}, {}},
    {"M-135", {{"M-135", 1.0}}, {}, {}},
    {"M+135", {{"M+110", 1.0}}, {}, {}},
    {"M-135", {{"M-110", 1.0}}, {}, {}},
    {"M+135", {{"M+030", _1_sqrt2}}, {}, {}},
    {"M-135", {{"M-030", _1_sqrt2}}, {}, {}},
    {"M+180", {{"M+180", 1.0}}, {}, {}},
    {"M+180", {{"M+135", _1_sqrt2}, {"M-135", _1_sqrt2}},{},{}},
    {"M+180",{{"M+110", _1_sqrt2}, {"M-110", _1_sqrt2}},{},{}},
    {"M+180",{{"M+030", 0.5}, {"M-030", 0.5}},{},{}},
    {"U+000", {{"U+000", 1.0}}, {}, {}},
    {"U+000",{{"U+030", _1_sqrt2}, {"U-030", _1_sqrt2}},{},{}},
    {"U+000",{{"U+045", _1_sqrt2}, {"U-045", _1_sqrt2}},{},{}},
    {"U+000", {{"M+000", 1.0}}, {}, {}},
    {"U+000",{{"M+030", _1_sqrt2}, {"M-030", _1_sqrt2}},{},{}},
    {"U+030", {{"U+030", 1.0}}, {}, {}},
    {"U-030", {{"U-030", 1.0}}, {}, {}},
    {"U+030", {{"U+045", 1.0}}, {}, {}},
    {"U-030", {{"U-045", 1.0}}, {}, {}},
    {"U+030", {{"M+030", 1.0}}, {}, {}},
    {"U-030", {{"M-030", 1.0}}, {}, {}},
    {"U+045", {{"U+045", 1.0}}, {}, {}},
    {"U-045", {{"U-045", 1.0}}, {}, {}},
    {"U+045", {{"U+030", 1.0}}, {}, {}},
    {"U-045", {{"U-030", 1.0}}, {}, {}},
    {"U+045", {{"M+030", 1.0}}, {}, {}},
    {"U-045", {{"M-030", 1.0}}, {}, {}},
    {"U+090", {{"U+090", 1.0}}, {}, {}},
    {"U-090", {{"U-090", 1.0}}, {}, {}},
    {"U+090",{{"U+045", sqrt2_3}, {"UH+180", _1_sqrt3}},{"9+10+3"},{}},
    {"U-090",{{"U-045", sqrt2_3}, {"UH+180", _1_sqrt3}},{"9+10+3"},{}},
    {"U+090",{{"U+030", _1_sqrt2}, {"U+110", _1_sqrt2}},{},{}},
    {"U-090",{{"U-030", _1_sqrt2}, {"U-110", _1_sqrt2}},{},{}},
    {"U+090",{{"U+045", _1_sqrt2}, {"U+135", _1_sqrt2}},{},{}},
    {"U-090",{{"U-045", _1_sqrt2}, {"U-135", _1_sqrt2}},{},{}},
    {"U+090", {{"M+090", 1.0}}, {}, {}},
    {"U-090", {{"M-090", 1.0}}, {}, {}},
    {"U+090", {{"U+030", _1_sqrt2}, {"M+110", _1_sqrt2}}, {}, {}},
    {"U-090",{{"U-030", _1_sqrt2}, {"M-110", _1_sqrt2}}, {}, {}},
    {"U+090", {{"M+030", _1_sqrt2}, {"M+110", _1_sqrt2}}, {}, {}},
    {"U-090", {{"M-030", _1_sqrt2}, {"M-110", _1_sqrt2}}, {},{}},
    {"U+090", {{"M+030", _1_sqrt2}}, {}, {}},
    {"U-090", {{"M-030", _1_sqrt2}}, {}, {}},
    {"U+110", {{"U+110", 1.0}}, {}, {}},
    {"U-110", {{"U-110", 1.0}}, {}, {}},
    {"U+110", {{"U+135", 1.0}}, {}, {}},
    {"U-110", {{"U-135", 1.0}}, {}, {}},
    {"U+110", {{"U+045", _1_sqrt2}, {"UH+180", _1_sqrt2}},{}, {}},
    {"U-110", {{"U-045", _1_sqrt2}, {"UH+180", _1_sqrt2}},{},{}},
    {"U+110", {{"M+110", 1.0}}, {}, {}},
    {"U-110", {{"M-110", 1.0}}, {}, {}},
    {"U+110", {{"M+135", 1.0}}, {}, {}},
    {"U-110", {{"M-135", 1.0}}, {}, {}},
    {"U+110", {{"M+030", _1_sqrt2}}, {}, {}},
    {"U-110", {{"M-030", _1_sqrt2}}, {}, {}},
    {"U+135", {{"U+135", 1.0}}, {}, {}},
    {"U-135", {{"U-135", 1.0}}, {}, {}},
    {"U+135", {{"U+110", 1.0}}, {}, {}},
    {"U-135", {{"U-110", 1.0}}, {}, {}},
    {"U+135", {{"U+045", _1_sqrt3}, {"UH+180", sqrt2_3}},{"9+10+3"},{}},
    {"U-135", {{"U-045", _1_sqrt3}, {"UH+180", sqrt2_3}}, {"9+10+3"}, {}},
    {"U+135", {{"U+045", _1_sqrt2}, {"UH+180", _1_sqrt2}}, {},{}},
    {"U-135", {{"U-045", _1_sqrt2}, {"UH+180", _1_sqrt2}}, {},{}},
    {"U+135", {{"M+135", 1.0}}, {}, {}},
    {"U-135", {{"M-135", 1.0}}, {}, {}},
    {"U+135", {{"M+110", 1.0}}, {}, {}},
    {"U-135", {{"M-110", 1.0}}, {}, {}},
    {"U+135", {{"M+030", _1_sqrt2}}, {}, {}},
    {"U-135", {{"M-030", _1_sqrt2}}, {}, {}},
    {"U+180", {{"U+180", 1.0}}, {}, {}},
    {"U+180", {{"UH+180", 1.0}}, {}, {}},
    {"U+180",{{"U+135", _1_sqrt2}, {"U-135", _1_sqrt2}},{}, {}},
    {"U+180", {{"U+110", _1_sqrt2}, {"U-110", _1_sqrt2}}, {},{}},
    {"U+180", {{"M+135", _1_sqrt2}, {"M-135", _1_sqrt2}}, {},{}},
    {"U+180",{{"M+110", _1_sqrt2}, {"M-110", _1_sqrt2}},{},{}},
    {"U+180",{{"M+030", 0.5}, {"M-030", 0.5}},{},{}},
    {"UH+180", {{"UH+180", 1.0}}, {}, {}},
    {"UH+180", {{"U+180", 1.0}}, {}, {}},
    {"UH+180",{{"U+135", _1_sqrt2}, {"U-135", _1_sqrt2}},{},{}},
    {"UH+180",{{"U+110", _1_sqrt2}, {"U-110", _1_sqrt2}},{},{}},
    {"UH+180",{{"M+135", _1_sqrt2}, {"M-135", _1_sqrt2}},{},{}},
    {"UH+180",{{"M+110", _1_sqrt2}, {"M-110", _1_sqrt2}},{},{}},
    {"UH+180",{{"M+030", 0.5}, {"M-030", 0.5}},{},{}},
    {"T+000", {{"T+000", 1.0}}, {}, {}},
    {"T+000",{{"U+045", 0.5},{"U-045", 0.5},{"U+135", 0.5},{"U-135", 0.5}},{},{}},
    {"T+000",{{"U+030", 0.5},{"U-030", 0.5},{"U+110", 0.5},{"U-110", 0.5}},{},{}},
    {"T+000",{{"U+045", _1_sqrt3},{"U-045", _1_sqrt3},{"UH+180", _1_sqrt3}},{},{}},
    {"T+000",{{"U+045", 0.5},{"U-045", 0.5},{"M+135", 0.5},{"M-135", 0.5}},{},{}},
    {"T+000",{{"U+030", 0.5},{"U-030", 0.5},{"M+110", 0.5},{"M-110", 0.5}},{},{}},
    {"T+000",{{"M+030", 0.5},{"M-030", 0.5},{"M+135", 0.5},{"M-135", 0.5}},{},{}},
    {"T+000",{{"M+030", 0.5},{"M-030", 0.5},{"M+110", 0.5},{"M-110", 0.5}},{},{}},
    {"T+000",{{"M+030", 0.5}, {"M-030", 0.5}},{},{}},
    {"B+000", {{"B+000", 1.0}}, {}, {}},
    {"B+000", {{"M+000", 1.0}}, {}, {}},
    {"B+000",{{"M+030", _1_sqrt2}, {"M-030", _1_sqrt2}},{},{}},
    {"B+045", {{"B+045", 1.0}}, {}, {}},
    {"B-045", {{"B-045", 1.0}}, {}, {}},
    {"B+045", {{"M+030", 1.0}}, {}, {}},
    {"B-045", {{"M-030", 1.0}}, {}, {}},
    {"LFE1", {{"LFE1", 1.0}}, {"9+10+3", "3+7+0"}, {"9+10+3", "3+7+0"}},
    {"LFE2", {{"LFE2", 1.0}}, {"9+10+3", "3+7+0"}, {"9+10+3", "3+7+0"}},
    {"LFE1", {{"LFE1", _1_sqrt2}}, {"9+10+3", "3+7+0"}, {}},
    {"LFE2", {{"LFE1", _1_sqrt2}}, {"9+10+3", "3+7+0"}, {}},
    {"LFE1", {{"LFE1", 1.0}}, {}, {}},
    };

}
